function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

(function ($) {
  "use strict";

  $(document).ready(function () {
    var mapContainer = $('#mapBox');
    var lat = mapContainer.attr('data-latitude');
    var lng = mapContainer.attr('data-longitude');
    var zoom = mapContainer.attr('data-zoom');
    var mapOption = {
      dragging: true,
      zoomControl: true,
      scrollWheelZoom: true
    };
    var map = L.map('mapBox', mapOption).setView([lat, lng], zoom);
    L.tileLayer(leafletApiPath, {
      maxZoom: 18,
      tileSize: 512,
      zoomOffset: -1,
      attribution: '© <a target="_blank" rel="nofollow" href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
    }).addTo(map);
    map.on('moveend', function (e) {
      var centerLocation = map.getCenter();
      $('#LocationLatitude').val(centerLocation.lat);
      $('#LocationLongitude').val(centerLocation.lng);
    });
    map.on('dragstart', function () {
      $('.region-map .marker').addClass('dragging');
    });
    map.on('dragend', function () {
      $('.region-map .marker').removeClass('dragging');
    });

    function handleMapCenterAfterSelectChange($select, zoom) {
      var selectedOption = $select.find('option:checked');
      var mapCenter = selectedOption.attr('data-center');
      mapCenter = mapCenter.split(',');

      if (map) {
        map.setView([mapCenter[0], mapCenter[1]], zoom);
      }
    }

    $('body').on('change', '#citySelectBox select', function () {
      handleMapCenterAfterSelectChange($(this), 13);
    });
    $('body').on('change', '#provinceSelectBox select', function () {
      handleMapCenterAfterSelectChange($(this), 8);
      var type = $('input[name="type"]').val();
      var $this = $(this);

      if (type === 'district') {
        $this.addClass('loadingbar gray').prop('disabled', true);
        $.get(adminPanelPrefix + '/regions/citiesByProvince/' + $this.val(), function (result) {
          if (result && result.code === 200) {
            var selectBox = $('#citySelectBox');
            var html = '<option value="">' + selectCityLang + '</option>';

            if (result.cities && result.cities.length) {
              var _iterator = _createForOfIteratorHelper(result.cities),
                  _step;

              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  var city = _step.value;
                  html += '<option value="' + city.id + '" data-center="' + city.geo_center.join(',') + '">' + city.title + '</option>';
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }
            }

            selectBox.find('select').prop('disabled', false);
            selectBox.find('select').html(html);
            selectBox.removeClass('d-none');
            $this.removeClass('loadingbar gray').prop('disabled', false);
          }
        });
      }
    });
    $('body').on('change', '#countrySelectBox select', function () {
      var type = $('input[name="type"]').val();
      var $this = $(this);
      handleMapCenterAfterSelectChange($(this), 5);

      if (type !== 'country' && type !== 'province') {
        $this.addClass('loadingbar gray').prop('disabled', true);
        $.get(adminPanelPrefix + '/regions/provincesByCountry/' + $this.val(), function (result) {
          if (result && result.code === 200) {
            var selectBox = $('#provinceSelectBox');
            var html = '<option value="">' + selectProvinceLang + '</option>';

            if (result.provinces && result.provinces.length) {
              var _iterator2 = _createForOfIteratorHelper(result.provinces),
                  _step2;

              try {
                for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                  var province = _step2.value;
                  html += '<option value="' + province.id + '" data-center="' + province.geo_center.join(',') + '">' + province.title + '</option>';
                }
              } catch (err) {
                _iterator2.e(err);
              } finally {
                _iterator2.f();
              }
            }

            selectBox.find('select').prop('disabled', false);
            selectBox.find('select').html(html);
            selectBox.removeClass('d-none');
            $this.removeClass('loadingbar gray').prop('disabled', false);
          }
        });
      }
    });
  });
})(jQuery);
