/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 32);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./resources/js/admin/rewards/rewards_items.js":
/*!*****************************************************!*\
  !*** ./resources/js/admin/rewards/rewards_items.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

(function () {
  "use strict";

  var $rewardSettingModal = $('#rewardSettingModal');
  $('body').on('click', '.js-add-new-reward', function (e) {
    $rewardSettingModal.modal('show');
  });
  $('body').on('click', '.js-save-reward', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar gray').prop('disabled', true);
    var $form = $rewardSettingModal.find('form');
    var data = $form.serializeObject();
    $.post(adminPanelPrefix + '/rewards/items', data, function (result) {
      Swal.fire({
        icon: 'success',
        html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
        showConfirmButton: false,
        width: '25rem'
      });
      setTimeout(function () {
        window.location.reload();
      }, 500);
    }).fail(function (err) {
      $this.removeClass('loadingbar gray').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('click', '.js-edit-reward', function (e) {
    var $this = $(this);
    var id = $this.attr('data-id');
    var $form = $rewardSettingModal.find('form');
    removeAppendedInput();
    loadingSwl();
    $.get("".concat(adminPanelPrefix, "/rewards/items/").concat(id), function (result) {
      if (result && result.reward) {
        var reward = result.reward;
        $rewardSettingModal.find('input[name="score"]').val(reward.score);
        $rewardSettingModal.find('select[name="type"]').val(reward.type);
        $rewardSettingModal.find('input[name="condition"]').val(reward.condition);
        $rewardSettingModal.find('input[name="status"]').prop('checked', reward.status === 'active');
        $form.prepend("<input type=\"hidden\" name=\"reward_id\" value=\"".concat(id, "\"/>"));
        handleVisibilityInputsByType(reward.type);
        $rewardSettingModal.modal('show');
        setTimeout(function () {
          Swal.close();
        }, 500);
      }
    });
  });
  $('body').on('change', '#rewardSettingModal select[name="type"]', function () {
    var value = $(this).val();
    handleVisibilityInputsByType(value);
  });

  function handleVisibilityInputsByType(type) {
    var scoreInput = $('.js-score-input');
    var conditionInput = $('.js-condition-input');
    scoreInput.removeClass('d-none');

    if (type === 'badge') {
      scoreInput.addClass('d-none');
    }

    conditionInput.addClass('d-none');

    if ($.inArray(type, ['charge_wallet', 'account_charge', 'buy', 'buy_store_product']) !== -1) {
      conditionInput.removeClass('d-none');
    }
  }

  function removeAppendedInput() {
    var input = $rewardSettingModal.find('input[name="reward_id"]');

    if (input) {
      input.remove();
    }
  }
})(jQuery);

/***/ }),

/***/ 32:
/*!***********************************************************!*\
  !*** multi ./resources/js/admin/rewards/rewards_items.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /home/mostafa/projects/webinar/resources/js/admin/rewards/rewards_items.js */"./resources/js/admin/rewards/rewards_items.js");


/***/ })

/******/ });