/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!************************************!*\
  !*** ./resources/js/panel/quiz.js ***!
  \************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  // *******************
  // create
  // *****************
  $('body').on('click', '#add_multiple_question', function (e) {
    e.preventDefault();
    var quiz_id = $(this).attr('data-quiz-id');
    var multipleQuestionModal = $('.multipleQuestionModal' + quiz_id);
    var clone = multipleQuestionModal.clone();
    var id = 'correctAnswerSwitch' + randomString();
    clone.find('label.js-switch').attr('for', id);
    clone.find('input.js-switch').attr('id', id);
    var random_id = randomString();
    clone.find('.main-answer-row').removeClass('main-answer-row').addClass('main-answer-box');
    var copyHtml = clone.prop('innerHTML');
    copyHtml = copyHtml.replaceAll('record', random_id);
    copyHtml = copyHtml.replaceAll('ans_tmp', 'ans_temp');
    clone.html(copyHtml);
    Swal.fire({
      html: clone.html(),
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '48rem'
    });
  });
  $('body').on('click', '.add-answer-btn', function (e) {
    e.preventDefault();
    var mainRow = $('.add-answer-container .main-answer-box');
    var copy = mainRow.clone();
    copy.removeClass('main-answer-box');
    copy.find('.answer-remove').removeClass('d-none');
    var id = 'correctAnswerSwitch' + randomString();
    copy.find('label.js-switch').attr('for', id);
    copy.find('input.js-switch').attr('id', id);
    copy.find('input[type="checkbox"]').prop('checked', false);
    var copyHtml = copy.prop('innerHTML');
    var nameId = randomString();
    copyHtml = copyHtml.replaceAll('ans_temp', nameId);
    copyHtml = copyHtml.replace(/\[\d+\]/g, '[' + nameId + ']');
    copy.html(copyHtml);
    copy.find('input[type="checkbox"]').prop('checked', false);
    copy.find('input[type="text"]').val('');
    mainRow.parent().append(copy);
  });
  $('body').on('click', '.answer-remove', function (e) {
    e.preventDefault();
    $(this).closest('.add-answer-card').remove();
  });
  function randomString() {
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    for (var i = 0; i < 5; i++) text += possible.charAt(Math.floor(Math.random() * possible.length));
    return text;
  }
  $('body').on('click', '#add_descriptive_question', function (e) {
    e.preventDefault();
    var quiz_id = $(this).attr('data-quiz-id');
    var multipleQuestionModal = $('.descriptiveQuestionModal' + quiz_id);
    var clone = multipleQuestionModal.clone();
    var random_id = randomString();
    var copyHtml = clone.prop('innerHTML');
    copyHtml = copyHtml.replaceAll('record', random_id);
    copyHtml = copyHtml.replaceAll('ans_tmp', 'ans_temp');
    clone.html(copyHtml);
    Swal.fire({
      html: clone.html(),
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '48rem'
    });
  });

  /*$('body').on('change', '.js-switch', function () {
      const $this = $(this);
      const parent = $this.closest('.js-switch-parent');
       if (this.checked) {
          $('.js-switch').each(function () {
              const switcher = $(this);
              const switcher_parent = switcher.closest('.js-switch-parent');
              const switcher_input = switcher_parent.find('input[type="checkbox"]');
              switcher_input.prop('checked', false);
          });
           $this.prop('checked', true);
      }
  });*/

  $('body').on('click', '.save-question', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.quiz-questions-form');
    var data = serializeObjectByTag(form);
    var action = form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });

  // *******************
  // edit
  // *****************

  $('body').on('click', '.edit_question', function (e) {
    e.preventDefault();
    var $this = $(this);
    var question_id = $this.attr('data-question-id');
    loadingSwl();
    $.get('/panel/quizzes-questions/' + question_id + '/edit', function (result) {
      if (result && result.html) {
        var $html = '<div id="editQuestion">' + result.html + '</div>';
        Swal.fire({
          html: $html,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '48rem',
          onOpen: function onOpen() {
            var editModal = $('#editQuestion');
            editModal.find('.main-answer-row').removeClass('main-answer-row').addClass('main-answer-box');
            var random_id = randomString();
            editModal.find('.panel-file-manager').first().attr('data-input', random_id);
            editModal.find('.lfm-input').first().attr('id', random_id);

            /*const id = 'correctAnswerSwitch' + randomString();
            editModal.find('label.js-switch').first().attr('for', id);
            editModal.find('input.js-switch').first().attr('id', id);*/

            feather.replace();
          }
        });
      }
    });
  });
  $('body').on('click', '.js-submit-quiz-form', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.quiz-form');
    var data = serializeObjectByTag(form);
    var action = form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue">' + saveSuccessLang + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          if (result.redirect_url && result.redirect_url !== '') {
            window.location.href = result.redirect_url;
          } else {
            window.location.reload();
          }
        }, 2000);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('change', '.js-ajax-webinar_id', function (e) {
    var $this = $(this);
    var webinarId = $this.val();
    var path = '/panel/chapters/getAllByWebinarId/' + webinarId;
    var $chapterSelection = $('.js-ajax-chapter_id');
    $chapterSelection.addClass('loadingbar gray');
    $.get(path, function (result) {
      if (result && result.chapters) {
        var html = '<option value="">' + quizzesSectionLang + '</option>';
        Object.keys(result.chapters).forEach(function (key) {
          var chapter = result.chapters[key];
          html += '<option value="' + chapter.id + '">' + chapter.title + '</option>';
        });
        $chapterSelection.removeClass('loadingbar gray');
        $chapterSelection.html(html);
      }
    });
  });
  $('body').on('change', '.js-ajax-display_limited_questions', function () {
    var $input = $('.js-display-limited-questions-count-field');
    $input.find('input').val('');
    if (this.checked) {
      $input.removeClass('d-none');
    } else {
      $input.addClass('d-none');
    }
  });
  $(document).ready(function () {
    var style = getComputedStyle(document.body);
    var primaryColor = style.getPropertyValue('--primary');
    function updateToDatabase(table, quizId, idString) {
      $.post('/panel/quizzes/' + quizId + '/order-items', {
        table: table,
        items: idString
      }, function (result) {
        if (result && result.title && result.msg) {
          $.toast({
            heading: result.title,
            text: result.msg,
            bgColor: primaryColor,
            textColor: 'white',
            hideAfter: 10000,
            position: 'bottom-right',
            icon: 'success'
          });
        }
      });
    }
    function setSortable(target) {
      if (target.length) {
        target.sortable({
          group: 'no-drop',
          handle: '.move-icon',
          axis: "y",
          update: function update(e, ui) {
            var sortData = target.sortable('toArray', {
              attribute: 'data-id'
            });
            var table = e.target.getAttribute('data-order-table');
            var quizId = e.target.getAttribute('data-quiz');
            updateToDatabase(table, quizId, sortData.join(','));
          }
        });
      }
    }
    var items = [];
    var draggableContentLists = $('.draggable-questions-lists');
    if (draggableContentLists.length) {
      var _iterator = _createForOfIteratorHelper(draggableContentLists),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          items.push($(item).attr('data-drag-class'));
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
    if (items.length) {
      var _iterator2 = _createForOfIteratorHelper(items),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _item = _step2.value;
          var tag = $('.' + _item);
          if (tag.length) {
            setSortable(tag);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  });
})(jQuery);
/******/ })()
;