function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

(function ($) {
  "use strict";

  $('body').on('change', '.js-webinar-content-locale', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $(this).closest('.js-content-form');
    var locale = $this.val();
    var webinarId = $this.attr('data-webinar-id');
    var item_id = $this.attr('data-id');
    var relation = $this.attr('data-relation');
    var fields = $this.attr('data-fields');
    fields = fields.split(',');
    $this.addClass('loadingbar gray');
    var path = '/panel/webinars/' + webinarId + '/getContentItemByLocale';
    var data = {
      item_id: item_id,
      locale: locale,
      relation: relation
    };
    $.post(path, data, function (result) {
      if (result && result.item) {
        var item = result.item;
        Object.keys(item).forEach(function (key) {
          var value = item[key];

          if ($.inArray(key, fields) !== -1) {
            var element = $form.find('.js-ajax-' + key);
            element.val(value);
          }

          if (relation === 'textLessons' && key === 'content') {
            var summernoteTarget = $form.find('.js-content-' + item_id);

            if (summernoteTarget.length) {
              summernoteTarget.summernote('destroy');
              summernoteTarget.val(value);
              $('.js-hidden-content-' + item_id).val(value);

              if (jQuery().summernote) {
                makeSummernote(summernoteTarget, 400, function (contents, $editable) {
                  $('.js-hidden-content-' + item_id).val(contents);
                });
              }
            }
          }
        });
        $this.removeClass('loadingbar gray');
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar gray');
    });
  });
  $('body').on('change', '.js-quiz-question-locale', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $(this).closest('.quiz-questions-form');
    var locale = $this.val();
    var item_id = $this.attr('data-id');
    $this.addClass('loadingbar gray');
    var path = '/panel/quizzes-questions/' + item_id + '/getQuestionByLocale?locale=' + locale;
    $.get(path, function (result) {
      var question = result.question;

      if (question.type === 'descriptive') {
        var fields = ['title', 'correct'];
        Object.keys(question).forEach(function (key) {
          var value = question[key];

          if ($.inArray(key, fields) !== -1) {
            var element = $form.find('.js-ajax-' + key);
            element.val(value);
          }
        });
      } else {
        $form.find('.js-ajax-title').val(question.title);

        if (question.quizzes_questions_answers && question.quizzes_questions_answers.length) {
          var answers = question.quizzes_questions_answers;

          var _iterator = _createForOfIteratorHelper(answers),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var answer = _step.value;

              if (answer) {
                $form.find('.js-ajax-answer-title-' + answer.id).val(answer.title);
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }
      }

      $this.removeClass('loadingbar gray');
    }).fail(function (err) {
      $this.removeClass('loadingbar gray');
    });
  });
})(jQuery);
