$(function ($) {
  "use strict";

  function handleShowDay(unix) {
    var day = new persianDate(unix).day();
    var startDayTime = new persianDate(unix).startOf('day').unix();
    var endDayTime = new persianDate(unix).endOf('day').unix();
    var showThisDay = false; // availableDays is defined globally in blade

    for (var index2 in availableDays) {
      var disabled_day = Number(availableDays[index2]);

      if (disabled_day === day) {
        showThisDay = true;
      }
    }

    return showThisDay;
  }

  function handlePDatepicker() {
    $(".inline-reservation-calender").pDatepicker({
      inline: true,
      altField: '#inlineCalender',
      initialValue: true,
      calendarType: 'gregorian',
      initialValueType: true,
      autoClose: true,
      altFormat: 'DD MMMM YY',
      calendar: {
        gregorian: {
          locale: 'en'
        }
      },
      toolbox: {
        calendarSwitch: {
          enabled: false
        }
      },
      navigator: {
        scroll: {
          enabled: false
        },
        text: {
          btnNextText: '<',
          btnPrevText: ">"
        }
      },
      minDate: new persianDate().subtract('day', 0).valueOf(),
      checkDate: function checkDate(unix) {
        return handleShowDay(unix);
      },
      timePicker: {
        enabled: false
      },
      onSelect: function onSelect(unix) {
        var pDate = new persianDate(unix);
        var timestamp = pDate.startOf('day').unix();
        var dayLabel = pDate.format('dddd');
        var date = pDate.format('YYYY-MM-DD');
        $('#selectedDay').val(date);
        handleShowReservationTimes(timestamp, dayLabel, date);
      }
    });
  }

  if ($(".inline-reservation-calender").length) {
    handlePDatepicker();
  }

  function handleShowReservationTimes(timestamp, dayLabel, date) {
    var container = $('#PickTimeContainer');
    var body = $('#PickTimeBody');
    var availableTimes = $('#availableTimes');
    var loading = container.find('.loading-img');
    var user_id = container.attr('data-user-id');
    container.removeClass('d-none');
    $('html, body').animate({
      scrollTop: container.offset().top - window.innerHeight / 2
    }, 600);
    body.addClass('d-none');
    loading.removeClass('d-none');
    body.find('.selected_date span').text($('#inlineCalender').val());
    var data = {
      timestamp: timestamp,
      day_label: dayLabel,
      date: date
    };
    $.post('/users/' + user_id + '/availableTimes', data, function (result) {
      var html = '';

      if (result && typeof result.times !== "undefined") {
        Object.keys(result.times).forEach(function (key) {
          var item = result.times[key];
          html += '<div class="position-relative available-times ' + (item.can_reserve ? '' : 'disabled') + '">\n' + '<input type="radio" name="time" id="availableTime' + item.id + '" value="' + item.id + '" ' + (item.can_reserve ? '' : 'disabled') + ' data-type="' + item.meeting_type + '">\n' + '<label for="availableTime' + item.id + '">' + item.time + '</label>\n';

          if (!item.can_reserve) {
            html += '<span class="font-12 badge badge-danger text-white reserved-item">' + reservedLang + '</span>';
          }

          html += '<input type="hidden" class="js-time-description" value="' + item.description + '"/>';
          html += '</div>';
        });
        availableTimes.html(html);
      }
    }).always(function () {
      body.removeClass('d-none');
      loading.addClass('d-none');
    });
  }

  $('body').on('change', 'input[name="time"]', function (e) {
    if (this.checked) {
      var body = $('#PickTimeBody');
      var $this = $(this);
      var type = $this.attr('data-type');
      var time = $this.parent().find('label').text();
      var date = body.find('.selected_date span').text();
      body.find('.selected-date-time span').text(date + ' | ' + time);
      $('.js-finalize-reserve').removeClass('d-none');
      var onlineTypeReserve = $('input[value="online"]').closest('.meeting-type-reserve');
      var inPersonTypeReserve = $('input[value="in_person"]').closest('.meeting-type-reserve');
      onlineTypeReserve.removeClass('disabled');
      onlineTypeReserve.find('input').prop('disabled', false);
      inPersonTypeReserve.removeClass('disabled');
      inPersonTypeReserve.find('input').prop('disabled', false);

      if (type === 'in_person') {
        onlineTypeReserve.addClass('disabled');
        onlineTypeReserve.find('input').prop('disabled', true);
      }

      if (type === 'online') {
        inPersonTypeReserve.addClass('disabled');
        inPersonTypeReserve.find('input').prop('disabled', true);
      }

      var $timeDescription = $this.parent().find('.js-time-description');
      var $timeDescriptionCard = $('.js-time-description-card');

      if ($timeDescription && $timeDescription.val() && $timeDescription.val() !== 'null' && $timeDescription.val() !== 'undefined') {
        $timeDescriptionCard.removeClass('d-none');
        $timeDescriptionCard.text($timeDescription.val());
      } else {
        $timeDescriptionCard.addClass('d-none');
      }
    }
  });
  $('body').on('change', 'input[name="meeting_type"]', function (e) {
    $('#withGroupMeetingSwitch').prop('checked', false);
    $('.js-group-meeting-options').addClass('d-none');
    $('input[name="student_count"]').val(1);
    $('.wrunner').remove();

    if (this.checked) {
      var $this = $(this);
      var value = $this.val();
      var $jsGroupMeetingSwitch = $('.js-group-meeting-switch');
      var $jsOnlineGroupAmount = $('.js-online-group-amount');
      var $jsInPersonGroupAmount = $('.js-in-person-group-amount');
      $jsGroupMeetingSwitch.removeClass('d-none').addClass('d-flex');

      if (value === 'in_person') {
        $jsOnlineGroupAmount.addClass('d-none');
        $jsInPersonGroupAmount.removeClass('d-none');
      }

      if (value === 'online') {
        $jsOnlineGroupAmount.removeClass('d-none');
        $jsInPersonGroupAmount.addClass('d-none');
      }

      $('.js-reserve-btn').removeClass('d-none').addClass('d-flex');
      $('.js-reserve-description').removeClass('d-none');
    }
  });
  $('body').on('change', '#withGroupMeetingSwitch', function (e) {
    var $jsGroupMeetingOptions = $('.js-group-meeting-options');
    $('input[name="student_count"]').val(1);
    $('.wrunner').remove();

    if (this.checked) {
      $jsGroupMeetingOptions.removeClass('d-none');
      handleStudentCountRange();
    } else {
      $jsGroupMeetingOptions.addClass('d-none');
    }
  });
  $('body').on('click', '.js-submit-form', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $.post('/meetings/reserve', data, function (result) {
      $.toast({
        heading: result.title,
        text: result.msg,
        bgColor: result.status === 'success' ? '#43d477' : '#f63c3c',
        textColor: 'white',
        hideAfter: 10000,
        position: 'bottom-right',
        icon: result.status
      });

      if (result.status === 'success' && typeof result.redirect !== "undefined") {
        window.location.href = result.redirect;
      } else {
        $this.removeClass('loadingbar gray').prop('disabled', false);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar gray').prop('disabled', false);
    });
  });
  $('body').on('click', '#followToggle', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar primary').prop('disabled', true);
    var user_id = $this.attr('data-user-id');
    var path = '/users/' + user_id + '/follow';
    $.get(path, function (result) {
      $this.removeClass('loadingbar primary').prop('disabled', false);

      if (result && result.code === 200) {
        if (result.follow) {
          $this.removeClass('btn-primary').addClass('btn-danger');
          $this.text(unFollowLang);
        } else {
          $this.removeClass('btn-danger').addClass('btn-primary');
          $this.text(followLang);
        }
      }
    });
  });
  $('body').on('click', '.js-refresh-captcha', function (e) {
    e.preventDefault();
    refreshCaptcha();
  });
  $('body').on('click', '.js-send-message', function (e) {
    e.preventDefault();
    Swal.fire({
      html: $('#sendMessageModal').html(),
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      onOpen: function onOpen() {
        refreshCaptcha();
      },
      width: '42rem'
    });
  });
  $('body').on('click', '.js-send-message-submit', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue">' + messageSuccessSentLang + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 2000);
      } else {
        Swal.fire({
          icon: 'error',
          html: '<h3 class="font-20 text-center text-dark-blue">' + result.message + '</h3>',
          showConfirmButton: false
        });
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      refreshCaptcha();

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });

  function handleStudentCountRange() {
    var $studentCountRange = $('#studentCountRange');

    if ($studentCountRange && jQuery().wRunner) {
      var meeting_type = $('input[name="meeting_type"]:checked').val();

      if (meeting_type) {
        var minLimit = $studentCountRange.attr('data-minLimit');
        var maxLimit = meeting_type === 'in_person' ? $('#in_person_group_max_student').val() : $('#online_group_max_student').val();
        var $studentCountInput = $studentCountRange.find('input[name="student_count"]');
        var wtime = $studentCountRange.wRunner({
          type: 'single',
          limits: {
            minLimit: minLimit,
            maxLimit: maxLimit
          },
          singleValue: minLimit,
          step: 1
        });
        wtime.onValueUpdate(function (res) {
          $studentCountInput.val(res.value);
        });
      }
    }
  }
});
