/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 4);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./resources/js/parts/learningPage/forum.js":
/*!**************************************************!*\
  !*** ./resources/js/parts/learningPage/forum.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

(function () {
  "use strict";

  $('body').on('click', '#askNewQuestion', function (e) {
    e.preventDefault();
    var rand = randomString();
    var clone = $('#askNewQuestionModal').clone();
    var copyHtml = clone.prop('innerHTML');
    copyHtml = copyHtml.replaceAll('record', rand);
    clone.html(copyHtml);
    Swal.fire({
      html: clone.html(),
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '36rem'
    });
  });

  function handleForumPostForm(form, $this) {
    var data = serializeObjectByTag(form);
    var action = form.attr('action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        //window.location.reload();
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  }

  $('body').on('click', '.js-save-question', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('form');
    handleForumPostForm(form, $this);
  });
  $('body').on('click', '.js-save-question-answer', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('form');
    handleForumPostForm(form, $this);
  });
  $('body').on('click', '.js-reply-course-question', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('form');
    handleForumPostForm(form, $this);
  });
  $('body').on('click', '.js-edit-forum', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    loadingSwl();
    $.get(action, function (result) {
      if (result && result.forum) {
        var rand = randomString();
        var clone = $('#askNewQuestionModal').clone();
        var copyHtml = clone.prop('innerHTML');
        copyHtml = copyHtml.replaceAll('record', rand);
        clone.html('<div id="editQuestionModal">' + copyHtml + '</div>');
        Swal.fire({
          html: clone.html(),
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '36rem',
          onOpen: function onOpen() {
            var modal = $('#editQuestionModal');
            var form = modal.find('form');
            var path = form.attr('action');
            path = path.replaceAll('store', result.forum.id + '/update');
            form.attr('action', path);
            Object.keys(result.forum).forEach(function (key) {
              var value = result.forum[key];
              var element = form.find('[name="' + key + '"]');

              if (element && element.length) {
                element.val(value);
              }
            });
          }
        });
      } else {
        Swal.fire(oopsLang, somethingWentWrongLang, 'error');
      }
    }).fail(function (err) {
      Swal.fire(oopsLang, somethingWentWrongLang, 'error');
    });
  });
  $('body').on('click', '.js-edit-forum-answer', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    loadingSwl();
    $.get(action, function (result) {
      if (result && result.answer) {
        var rand = randomString();
        var clone = $('#editQuestionAnswerModal').clone();
        var copyHtml = clone.prop('innerHTML');
        copyHtml = copyHtml.replaceAll('record', rand);
        clone.html('<div id="editAnswerModal">' + copyHtml + '</div>');
        Swal.fire({
          html: clone.html(),
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '36rem',
          onOpen: function onOpen() {
            var modal = $('#editAnswerModal');
            var form = modal.find('form');
            var formAction = action.replaceAll('edit', 'update');
            form.attr('action', formAction);
            Object.keys(result.answer).forEach(function (key) {
              var value = result.answer[key];
              var element = form.find('[name="' + key + '"]');

              if (element && element.length) {
                element.val(value);
              }
            });
          }
        });
      } else {
        Swal.fire(oopsLang, somethingWentWrongLang, 'error');
      }
    }).fail(function (err) {
      Swal.fire(oopsLang, somethingWentWrongLang, 'error');
    });
  });
  $('body').on('click', '.question-forum-pin-btn, .js-btn-answer-un_pin, .js-btn-answer-pin, .js-btn-answer-mark_as_not_resolved, .js-btn-answer-mark_as_resolved', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    loadingSwl();
    $.post(action, {}, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + changesSavedSuccessfullyLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      } else {
        Swal.fire(oopsLang, somethingWentWrongLang, 'error');
      }
    }).fail(function (err) {
      Swal.fire(oopsLang, somethingWentWrongLang, 'error');
    });
  });
})(jQuery);

/***/ }),

/***/ 4:
/*!********************************************************!*\
  !*** multi ./resources/js/parts/learningPage/forum.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /home/mostafa/projects/webinar/resources/js/parts/learningPage/forum.js */"./resources/js/parts/learningPage/forum.js");


/***/ })

/******/ });