/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!****************************************************!*\
  !*** ./resources/js/panel/ai-content-generator.js ***!
  \****************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function () {
  "use strict";

  $('body').on('click', '.js-show-ai-content-drawer', function (e) {
    e.preventDefault();
    lockBodyScroll(true);
    $('.ai-content-generator-drawer').addClass('show');
  });
  $('body').on('click', '.js-right-drawer-close, .ai-content-generator-drawer-mask', function () {
    $('.ai-content-generator-drawer').removeClass('show');
    lockBodyScroll(false);
  });
  $('body').on('change', 'select[name="service_type"]', function () {
    var value = $(this).val();
    var $text = $('.js-text-templates-field');
    var $image = $('.js-image-templates-field');
    $text.addClass('d-none');
    $image.addClass('d-none');
    if (value === "text") {
      $text.removeClass('d-none');
    }
    if (value === "image") {
      $image.removeClass('d-none');
    }
  });
  $('body').on('change', '.js-text-service-templates', function () {
    var value = $(this).val();
    var $option = $(this).find('option:selected');
    var $lengthField = $('.js-service-length-field');
    var $forServiceField = $('.js-for-service-fields');
    var $questionField = $('.js-question-field');
    $questionField.addClass('d-none');
    $forServiceField.addClass('d-none');
    $lengthField.addClass('d-none');
    $lengthField.find('input').val('');
    if ($option.attr('data-enable-length') === "yes") {
      $lengthField.removeClass('d-none');
      var length = $option.attr('data-length');
      if (length && length > 0) {
        $lengthField.find('input').attr('max', length);
      }
    }
    if (value === "custom_text") {
      $questionField.removeClass('d-none');
    } else {
      $forServiceField.removeClass('d-none');
    }
  });
  $('body').on('change', '.js-image-service-templates', function () {
    var value = $(this).val();
    var $imageSizeField = $('.js-image-size-field');
    var $imageKeywordField = $('.js-image-keyword-field');
    var $imageQuestionField = $('.js-image-question-field');
    $imageSizeField.addClass('d-none');
    $imageSizeField.find('select').val('');
    $imageKeywordField.addClass('d-none');
    $imageKeywordField.find('input').val('');
    $imageQuestionField.addClass('d-none');
    $imageQuestionField.find('input').val('');
    if (value === "custom_image") {
      $imageSizeField.removeClass('d-none');
      $imageQuestionField.removeClass('d-none');
    } else {
      $imageKeywordField.removeClass('d-none');
    }
  });
  $('body').on('keyup', '.js-service-length-field input', function () {
    var $this = $(this);
    var value = $this.val();
    var max = $this.attr('max');
    var error = $this.attr('data-max-error');
    var $errorDiv = $this.closest('.form-group').find('.invalid-feedback');
    $this.removeClass('is-invalid');
    $errorDiv.text('');
    if (Number(value) > Number(max)) {
      $this.val(max);
      $this.addClass('is-invalid');
      $errorDiv.text("".concat(error, " ").concat(max));
    }
  });
  $('body').on('click', '.js-submit-ai-content-form', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $textCard = $('#generatedTextContents');
    var $imagesCard = $('.js-image-generated');
    $imagesCard.addClass('d-none');
    $textCard.addClass('d-none');
    $.post(action, data, function (result) {
      if (result.code === 200) {
        if (result.data) {
          if (result.data.contents && Object.keys(result.data.contents).length) {
            $textCard.removeClass('d-none');
            $textCard.html('');
            var _iterator = _createForOfIteratorHelper(result.data.contents),
              _step;
            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var content = _step.value;
                var html = makeTextContentHtml(content);
                $textCard.append(html);
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }
          }
          if (result.data.images && Object.keys(result.data.images).length) {
            var $imagesCardContent = $imagesCard.find('.js-content');
            $imagesCard.removeClass('d-none');
            $imagesCardContent.html('');
            var _iterator2 = _createForOfIteratorHelper(result.data.images),
              _step2;
            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var image = _step2.value;
                var _html = "<a href=\"".concat(image, "\" target=\"_blank\" class=\"d-block image-generated-card\">\n                                    <img src=\"").concat(image, "\" alt=\"image\" class=\"img-cover rounded-sm\">\n                                </a>");
                $imagesCardContent.append(_html);
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        }
      }
      $this.removeClass('loadingbar primary').prop('disabled', false);
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  function makeTextContentHtml(text) {
    return "<div class=\"js-text-generated mt-20 p-15 bg-info-light border-gray300 rounded-sm\">\n            <div class=\"d-flex align-items-center justify-content-between\">\n                <h4 class=\"font-14 text-gray\">".concat(generatedContentLang, "</h4>\n\n                <div class=\"form-group mb-0\">\n                    <button type=\"button\" class=\"btn-transparent d-flex align-items-center js-copy-content\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"").concat(copyLang, "\" data-copy-text=\"").concat(copyLang, "\" data-done-text=\"").concat(doneLang, "\">\n                        <i data-feather=\"copy\" width=\"18\" height=\"18\" class=\"text-gray\"></i>\n                        <span class=\"text-gray font-12 ml-5\">").concat(copyLang, "</span>\n                    </button>\n                </div>\n            </div>\n\n            <div class=\"mt-15 font-14 text-gray js-content\">").concat(text, "</div>\n        </div>");
  }
  var copyTimeout;
  $('body').on('click', '.js-copy-content', function (e) {
    e.preventDefault();
    var $this = $(this);
    var copyText = $this.attr('data-copy-text');
    var doneText = $this.attr('data-done-text');
    var contentToCopy = $this.closest('.js-text-generated').find('.js-content').text();
    var tempTextarea = $('<textarea>').val(contentToCopy).appendTo('body').select();
    document.execCommand('copy');

    // Remove the temporary textarea
    tempTextarea.remove();
    var $span = $this.find('span');
    $span.text(doneText);
    if (copyTimeout) {
      clearTimeout(copyTimeout);
    }
    copyTimeout = setTimeout(function () {
      $span.text(copyText);
    }, 1500);
  });
})(jQuery);
/******/ })()
;